/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.xfw.pa.tasks.spi;

import com.ibm.hwmca.base.managed.BaseTower;
import com.ibm.hwmca.base.pa.GetServiceHistorySummaryData;
import com.ibm.hwmca.base.pa.ServiceHistorySummaryData;
import com.ibm.hwmca.base.pa.ServiceHistorySummaryDataElement;
import com.ibm.hwmca.base.pa.problem.CloseAllProblems;
import com.ibm.hwmca.base.pa.problem.CloseParms;
import com.ibm.hwmca.base.util.BaseMessageText;
import com.ibm.hwmca.base.util.BaseTextBundle;
import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.interfaces.ServiceDataProvider;
import com.ibm.hwmca.fw.managed.HMC;
import com.ibm.hwmca.fw.managed.ManagedObjectManager;
import com.ibm.hwmca.fw.managed.ObjectId;
import com.ibm.hwmca.fw.managed.User;
import com.ibm.hwmca.fw.report.CompletionReport;
import com.ibm.hwmca.fw.report.CompletionReportCode;
import com.ibm.hwmca.fw.report.ReportListenerAdapter;
import com.ibm.hwmca.fw.task.UserContext;
import com.ibm.hwmca.fw.tasklet.PanelBean;
import com.ibm.hwmca.fw.tasklet.TaskletException;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.MsgType;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.fw.util.WorkListener;
import com.ibm.hwmca.fw.util.WorkPerformer;
import com.ibm.hwmca.fw.util.WorkThread;
import com.ibm.hwmca.xfw.pa.tasks.XFrameServiceHistoryServerTasklet;
import com.ibm.hwmca.xfw.panel.pa.svchist.ProblemSummaryBean;
import com.ibm.hwmca.xfw.panel.pa.svchist.RepairInformationBean;
import com.ibm.hwmca.xfw.panel.pa.svchist.ServiceHistorySummaryBean;
import com.ibm.hwmca.xfw.panel.pa.svchist.ServiceHistorySummaryBeanReadOnly;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class ServiceHistoryServerTasklet
extends XFrameServiceHistoryServerTasklet {
    private static final String VERSION = "Ver 1.0, Rel 0.3";
    private static final String TRACE_MASKT = "XSHSHTAT";
    private static final String TRACE_MASKF = "XSHSHTAF";
    private static final String TRACE_MASKD = "XSHSHTAD";
    private static final boolean UNIT_TEST = true;
    private HashMap _sdpMap = new HashMap(32);
    private String _workingProblem = null;
    private String _workingSystem = null;
    private boolean _readOnly = false;
    private boolean _displayedReadOnly = false;
    private static final String SERVICE_INTERFACE = "com.ibm.hwmca.fw.interfaces.ServiceDataProvider";
    static /* synthetic */ Class class$com$ibm$hwmca$fw$interfaces$ServiceDataProvider;

    public void logException(Throwable throwable) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ServiceHistorySummaryBean getServiceHistorySummaryBean() throws TaskletException {
        Trace.trace("XSHSHTAD", "--> getServiceHistorySummaryBean Ver 1.0, Rel 0.3");
        shsb = null;
        this.showBusyDialog(new LocalizableText(BaseTextBundle.getBundleName(), "service.history.title"), new LocalizableText(BaseTextBundle.getBundleName(), "servhist.busy.text"));
        if (this.getPresentationTaskParms().getTargetIds() == null) {
            Trace.trace("XSHSHTAD", "No targets. Running against the console.");
            try {
                Trace.trace("XSHSHTAD", "Get the Base Tower");
                baseTower = BaseTower.getBaseTower();
                Trace.trace("XSHSHTAD", "got it.");
                hmcSDP = (ServiceDataProvider)baseTower.getInterfaceImpl(ServiceHistoryServerTasklet.class$com$ibm$hwmca$fw$interfaces$ServiceDataProvider == null ? (ServiceHistoryServerTasklet.class$com$ibm$hwmca$fw$interfaces$ServiceDataProvider = ServiceHistoryServerTasklet.class$("com.ibm.hwmca.fw.interfaces.ServiceDataProvider")) : ServiceHistoryServerTasklet.class$com$ibm$hwmca$fw$interfaces$ServiceDataProvider);
                Trace.trace("XSHSHTAD", "Got the SDP =" + hmcSDP);
                if (hmcSDP == null) {
                    Trace.trace("XSHSHTAD", "Didn't find the interface. Throw Exception");
                    throw new TaskletException("Could find the interface");
                }
                shsb = hmcSDP.getServiceHistorySummaryData(HMC.getHMC().getObjectId());
                Trace.trace("XSHSHTAD", "back from the call");
                mapElement = new SystemMapping();
                mapElement._sdp = hmcSDP;
                mapElement._obId = baseTower.getObjectId();
                this._sdpMap.put(HMC.getHMC().getUIInfo().getTitle(), mapElement);
            }
            catch (Throwable thrown) {
                ex = new TaskletException(thrown);
                Trace.trace("XSHSHTAD", "Got anException = " + ServiceHistoryServerTasklet.getStackTrace(ex));
                throw ex;
            }
        }
        totalRequest = this.getPresentationTaskParms().getTargetIds().length;
        Trace.trace("XSHSHTAD", "got " + totalRequest + " targets to handle.");
        summaryReports = new ServiceHistorySummaryData[totalRequest];
        outerList = this.getPresentationTaskParms().getGroupedTargetIds();
        Trace.trace("XSHSHTAD", "got an outerList of " + outerList.size() + " elements");
        innerTargets = null;
        sumDataAdapter = new ReportListenerAdapter(this, summaryReports, this.getPresentationTaskParms().getTargetIds());
        i = 0;
        while (i < outerList.size()) {
            Trace.trace("XSHSHTAD", "Outer list set [" + i + "] data");
            innerTargets = (ObjectId[])outerList.get(i);
            j = 0;
            while (j < innerTargets.length) {
                Trace.trace("XSHSHTAD", "target id is " + innerTargets[j]);
                ++j;
            }
            gSHSumData = new GetServiceHistorySummaryData(sumDataAdapter);
            Trace.trace("XSHSHTAD", "start the work thread");
            WorkThread.invokeAsync((WorkListener)gSHSumData, (WorkPerformer)gSHSumData, innerTargets, "Service History data gatherer thread");
            ++i;
        }
        try {
            Trace.trace("XSHSHTAD", "wait for completion. State =" + String.valueOf(sumDataAdapter.isFinished()));
            gSHSumData = this;
            synchronized (gSHSumData) {
                while (true) {
                    if (sumDataAdapter.isFinished()) {
                        // MONITOREXIT @DISABLED, blocks:[1, 20, 4, 10] lbl55 : MonitorExitStatement: MONITOREXIT : gSHSumData
                        Trace.trace("XSHSHTAD", "Finshed.");
                        break;
                    }
                    try {
                        Trace.trace("XSHSHTAD", "wait!");
                        this.wait();
                        Trace.trace("XSHSHTAD", "wake up!!!");
                    }
                    catch (InterruptedException ie) {
                        // empty catch block
                    }
                }
            }
        }
        catch (Throwable thrown) {
            ex = new TaskletException(thrown);
            Trace.trace("XSHSHTAD", "Got anException = " + ServiceHistoryServerTasklet.getStackTrace(ex));
            throw ex;
        }
        Trace.trace("XSHSHTAD", "done. get the data");
        shsb = new ServiceHistorySummaryBeanReadOnly();
        i = 0;
        while (i < summaryReports.length) {
            block24: {
                block23: {
                    if (summaryReports[i].getCompletionCode() != CompletionReportCode.SUCCESS) break block23;
                    repList = summaryReports[i].getList();
                    title = ManagedObjectManager.getManagedObjectManager().get(summaryReports[i].getObjectId()).getUIInfo().getTitle();
                    j = 0;
                    if (true) ** GOTO lbl99
                }
                Trace.trace("XSHSHTAD", "Got a failure report for " + ManagedObjectManager.getManagedObjectManager().get(summaryReports[i].getObjectId()).getUIInfo().getTitle());
                break block24;
                do {
                    element = (ServiceHistorySummaryDataElement)repList.get(j);
                    shsb.addDataRow(element.getDate(), title, element.getProblemNumber(), element.getProblemState(), element.getProblemDescription());
                    mapElement = (SystemMapping)this._sdpMap.get(title);
                    if (mapElement != null) {
                        mapElement.addTime(element.getDate());
                    } else {
                        mapElement = new SystemMapping();
                        mapElement._sdp = summaryReports[i].getSdp();
                        mapElement._obId = summaryReports[i].getObjectId();
                        mapElement.addTime(element.getDate());
                        this._sdpMap.put(title, mapElement);
                    }
                    Trace.trace("XSHSHTAD", "Dump out the map here");
                    Trace.trace("XSHSHTAD", "early time is " + new Date(mapElement._earliestProblem));
                    Trace.trace("XSHSHTAD", "latest time is " + new Date(mapElement._latestProblem));
                    ++j;
lbl99:
                    // 2 sources

                } while (j < repList.size());
            }
            ++i;
        }
        Trace.trace("XSHSHTAD", "row count = " + shsb.getServiceHistoryTableRowCount());
        if (shsb.getServiceHistoryTableRowCount() == 0) {
            Trace.trace("XSHSHTAD", "row count is zero");
            ans = this.showMessageBox(true, new BaseMessageText("XSH3000"), new BaseMessageText("XSH3001"), MsgType.INFORMATION_MESSAGE, null);
        }
        if (shsb.isReadOnly()) {
            if (!this._displayedReadOnly) {
                Trace.trace("XSHSHTAD", "got a read only file");
                Trace.trace("XSHSHTAD", "set readonly true");
                this._readOnly = true;
                ans = this.showMessageBox(true, new BaseMessageText("XSH3000"), shsb.getReadMessage(), MsgType.INFORMATION_MESSAGE, null);
                this._displayedReadOnly = true;
            }
        } else {
            Trace.trace("XSHSHTAD", "got a read write file");
            Trace.trace("XSHSHTAD", "set readonly false");
            this._readOnly = false;
        }
        Trace.trace("XSHSHTAD", "<-- getServiceHistorySummaryBean ");
        this.destroyBusyDialog();
        return shsb;
    }

    public ProblemSummaryBean getProblemSummaryBean(String system, String problem) throws TaskletException {
        Trace.trace(TRACE_MASKD, "<--> getProblemSummaryBean for " + problem + " on sytem " + system);
        SystemMapping mapElement = (SystemMapping)this._sdpMap.get(system);
        ServiceDataProvider sdp = mapElement._sdp;
        ObjectId obId = mapElement._obId;
        Trace.trace(TRACE_MASKD, "system =" + system);
        Trace.trace(TRACE_MASKD, "sdp =" + sdp);
        Trace.trace(TRACE_MASKD, "sdp =" + obId);
        try {
            this.showBusyDialog(new LocalizableText(BaseTextBundle.getBundleName(), "service.history.title"), new LocalizableText(BaseTextBundle.getBundleName(), "servhist.busy.text"));
            ProblemSummaryBean psb = sdp.getProblemSummaryBean(obId, problem, system);
            this.destroyBusyDialog();
            return psb;
        }
        catch (Throwable thrown) {
            HException ex = new HException(thrown);
            Trace.trace(TRACE_MASKD, "Got anException = " + ServiceHistoryServerTasklet.getStackTrace(ex));
            return null;
        }
    }

    public RepairInformationBean getRepairInformationBean(String system, String problem) throws TaskletException {
        Trace.trace(TRACE_MASKD, "<--> getProblemSummaryBean for " + problem + " on sytem " + system);
        SystemMapping mapElement = (SystemMapping)this._sdpMap.get(system);
        ServiceDataProvider sdp = mapElement._sdp;
        ObjectId obId = mapElement._obId;
        Trace.trace(TRACE_MASKD, "system =" + system);
        Trace.trace(TRACE_MASKD, "sdp =" + sdp);
        Trace.trace(TRACE_MASKD, "sdp =" + obId);
        try {
            this.showBusyDialog(new LocalizableText(BaseTextBundle.getBundleName(), "service.history.title"), new LocalizableText(BaseTextBundle.getBundleName(), "servhist.busy.text"));
            RepairInformationBean rib = sdp.getRepairInformationBean(obId, problem, system);
            this.destroyBusyDialog();
            if (rib == null) {
                Trace.trace(TRACE_MASKF, "got a null => no service info. put up a message");
                LocalizableText ans = this.showMessageBox(true, new BaseMessageText("XSH3000"), new BaseMessageText("XSH3003"), MsgType.INFORMATION_MESSAGE, null);
            }
            return rib;
        }
        catch (Throwable thrown) {
            HException ex = new HException(thrown);
            Trace.trace(TRACE_MASKD, "Got anException = " + ServiceHistoryServerTasklet.getStackTrace(ex));
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void closeProblems(String[] systems, String[] problems) throws TaskletException {
        Object sysName;
        Trace.trace(TRACE_MASKF, "-->closeProblems ");
        if (this._readOnly) {
            LocalizableText ans = this.showMessageBox(true, new BaseMessageText("XSH3000"), new BaseMessageText("XSH3004"), MsgType.INFORMATION_MESSAGE, null);
        } else {
            Trace.trace(TRACE_MASKD, "readonly not true");
        }
        Trace.trace(TRACE_MASKD, "[before sort]systems.length =" + systems.length);
        this.showBusyDialog(new LocalizableText(BaseTextBundle.getBundleName(), "service.history.title"), new LocalizableText(BaseTextBundle.getBundleName(), "servhist.close.text"));
        Arrays.sort(systems);
        Trace.trace(TRACE_MASKD, "[after sort]systems.length =" + systems.length);
        HashMap closeDataMap = new HashMap(40);
        ArrayList<String> problemList = null;
        String previousSystem = "";
        int i = 0;
        while (i < systems.length) {
            Trace.trace(TRACE_MASKD, "previousSyste name = [" + previousSystem + "]");
            Trace.trace(TRACE_MASKD, "current system name = " + systems[i]);
            if (systems[i].equals(previousSystem)) {
                Trace.trace(TRACE_MASKD, "still working on the same system");
                problemList.add(problems[i]);
                previousSystem = systems[i];
            } else {
                Trace.trace(TRACE_MASKD, "new system to work on");
                problemList = new ArrayList<String>(20);
                problemList.add(problems[i]);
                closeDataMap.put(systems[i], problemList);
            }
            ++i;
        }
        int systemCount = closeDataMap.size();
        Trace.trace(TRACE_MASKD, "Done with the sort");
        Trace.trace(TRACE_MASKD, "Got " + systemCount + " systems to work with");
        ObjectId[] anObjectArray = new ObjectId[systemCount];
        int ix = 0;
        Iterator systemNameIterator = closeDataMap.keySet().iterator();
        while (systemNameIterator.hasNext()) {
            SystemMapping mapElement = (SystemMapping)this._sdpMap.get((String)systemNameIterator.next());
            anObjectArray[ix] = mapElement._obId;
            Trace.trace(TRACE_MASKD, "anObjectArray[" + ix + "] is [" + anObjectArray[ix] + "]");
            ++ix;
        }
        CompletionReport[] compReportArray = new CompletionReport[systemCount];
        ReportListenerAdapter closeAdapter = new ReportListenerAdapter(this, compReportArray, anObjectArray);
        Trace.trace(TRACE_MASKD, "set up the close listener for " + systemCount + " systems.");
        Trace.trace(TRACE_MASKD, "compReportArray size = " + compReportArray.length);
        Trace.trace(TRACE_MASKD, "anObjectArray size = " + anObjectArray.length);
        systemNameIterator = closeDataMap.keySet().iterator();
        int i2 = 0;
        while (i2 < systemCount) {
            Trace.trace(TRACE_MASKD, "Working on systemMap[" + i2 + "]");
            if (systemNameIterator.hasNext()) {
                sysName = (String)systemNameIterator.next();
                List aProblemList = (List)closeDataMap.get(sysName);
                SystemMapping mapElement = (SystemMapping)this._sdpMap.get(sysName);
                ServiceDataProvider sdp = mapElement._sdp;
                ObjectId obId = mapElement._obId;
                Trace.trace(TRACE_MASKD, "system =" + (String)sysName);
                Trace.trace(TRACE_MASKD, "sdp =" + sdp);
                Trace.trace(TRACE_MASKD, "objectId =" + obId);
                try {
                    CloseAllProblems problemCloser = new CloseAllProblems(closeAdapter);
                    CloseParms closeParms = new CloseParms();
                    closeParms.setProblemList(aProblemList);
                    closeParms.setOpType("LIST");
                    closeParms.setSdp(sdp);
                    closeParms.setObjectId(obId);
                    Trace.trace(TRACE_MASKD, "start the closer work thread");
                    WorkThread.invokeAsync(problemCloser, problemCloser, closeParms, "Service History closeProblems() closer work thread");
                }
                catch (Throwable thrown) {
                    TaskletException ex = new TaskletException(thrown);
                    Trace.trace(TRACE_MASKD, "Got anException = " + ServiceHistoryServerTasklet.getStackTrace(ex));
                    throw ex;
                }
            }
            ++i2;
        }
        try {
            Trace.trace(TRACE_MASKD, "wait for completion. State =" + String.valueOf(closeAdapter.isFinished()));
            sysName = this;
            synchronized (sysName) {
                while (true) {
                    if (closeAdapter.isFinished()) {
                        // MONITOREXIT @DISABLED, blocks:[1, 17, 4, 11] lbl83 : MonitorExitStatement: MONITOREXIT : sysName
                        Trace.trace(TRACE_MASKD, "Finshed.");
                        break;
                    }
                    try {
                        Trace.trace(TRACE_MASKD, "wait!");
                        this.wait();
                        Trace.trace(TRACE_MASKD, "wake up!!!");
                    }
                    catch (InterruptedException ie) {
                        // empty catch block
                    }
                }
            }
        }
        catch (Throwable thrown) {
            TaskletException ex = new TaskletException(thrown);
            Trace.trace(TRACE_MASKD, "Got anException = " + ServiceHistoryServerTasklet.getStackTrace(ex));
            throw ex;
        }
        this.destroyBusyDialog();
        Trace.trace(TRACE_MASKF, "<--closeProblems ");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void closeAllProblems() throws TaskletException {
        Object mapElement;
        Trace.trace(TRACE_MASKF, "-->closeAllProblems ");
        this.showBusyDialog(new LocalizableText(BaseTextBundle.getBundleName(), "service.history.title"), new LocalizableText(BaseTextBundle.getBundleName(), "servhist.close.text"));
        int systemCount = this._sdpMap.size();
        Trace.trace(TRACE_MASKD, "got " + systemCount + " systems to close problems on.");
        ObjectId[] anObjectArray = new ObjectId[systemCount];
        int ix = 0;
        Iterator valueIterator = this._sdpMap.values().iterator();
        while (valueIterator.hasNext()) {
            SystemMapping mapElement2 = (SystemMapping)valueIterator.next();
            anObjectArray[ix] = mapElement2._obId;
            Trace.trace(TRACE_MASKD, "Target [" + ix + "] is " + anObjectArray[ix]);
            ++ix;
        }
        Trace.trace(TRACE_MASKD, "Set up the close Adapter for " + anObjectArray.length + " systems");
        CompletionReport[] compRepArray = new CompletionReport[1];
        ReportListenerAdapter closeAdapter = new ReportListenerAdapter(this, compRepArray, anObjectArray);
        valueIterator = this._sdpMap.values().iterator();
        int i = 0;
        while (i < systemCount) {
            Trace.trace(TRACE_MASKD, "Working on system [" + i + "]");
            if (valueIterator.hasNext()) {
                mapElement = (SystemMapping)valueIterator.next();
                ServiceDataProvider sdp = ((SystemMapping)mapElement)._sdp;
                ObjectId obId = ((SystemMapping)mapElement)._obId;
                Trace.trace(TRACE_MASKD, "CloseAll for");
                Trace.trace(TRACE_MASKD, "sdp =" + sdp);
                Trace.trace(TRACE_MASKD, "objectId =" + obId);
                try {
                    CloseAllProblems problemCloser = new CloseAllProblems(closeAdapter);
                    CloseParms closeParms = new CloseParms();
                    closeParms.setEndTime(((SystemMapping)mapElement)._latestProblem);
                    closeParms.setStartTime(((SystemMapping)mapElement)._earliestProblem);
                    closeParms.setOpType("ALL");
                    closeParms.setSdp(sdp);
                    closeParms.setObjectId(obId);
                    Trace.trace(TRACE_MASKD, "start the closer work thread");
                    WorkThread.invokeAsync(problemCloser, problemCloser, closeParms, "Service History closeAllProblems() closer work thread");
                }
                catch (Throwable thrown) {
                    TaskletException ex = new TaskletException(thrown);
                    Trace.trace(TRACE_MASKD, "Got anException = " + ServiceHistoryServerTasklet.getStackTrace(ex));
                    throw ex;
                }
            }
            ++i;
        }
        try {
            Trace.trace(TRACE_MASKD, "wait for completion. State =" + String.valueOf(closeAdapter.isFinished()));
            mapElement = this;
            synchronized (mapElement) {
                while (true) {
                    if (closeAdapter.isFinished()) {
                        // MONITOREXIT @DISABLED, blocks:[1, 4, 10, 12] lbl51 : MonitorExitStatement: MONITOREXIT : mapElement
                        Trace.trace(TRACE_MASKD, "Finshed.");
                        break;
                    }
                    try {
                        Trace.trace(TRACE_MASKD, "wait!");
                        this.wait();
                        Trace.trace(TRACE_MASKD, "wake up!!!");
                    }
                    catch (InterruptedException ie) {
                        // empty catch block
                    }
                }
            }
        }
        catch (Throwable thrown) {
            TaskletException ex = new TaskletException(thrown);
            Trace.trace(TRACE_MASKD, "Got anException = " + ServiceHistoryServerTasklet.getStackTrace(ex));
            throw ex;
        }
        this.destroyBusyDialog();
        Trace.trace(TRACE_MASKF, "<--closeAllProblems ");
    }

    public PanelBean getProblemAnalysisBean(String system, String problem) throws TaskletException {
        Trace.trace(TRACE_MASKD, "<--> getProblemAnalysisBean for " + problem + " on sytem " + system);
        SystemMapping mapElement = (SystemMapping)this._sdpMap.get(system);
        ServiceDataProvider sdp = mapElement._sdp;
        ObjectId obId = mapElement._obId;
        this._workingProblem = problem;
        this._workingSystem = system;
        Trace.trace(TRACE_MASKD, "set the working data to be system[" + this._workingSystem + "] problem " + this._workingProblem);
        try {
            this.showBusyDialog(new LocalizableText(BaseTextBundle.getBundleName(), "service.history.title"), new LocalizableText(BaseTextBundle.getBundleName(), "servhist.busy.text"));
            PanelBean pb = sdp.getProblemAnalysisBean(obId, problem, system);
            this.destroyBusyDialog();
            return pb;
        }
        catch (Throwable thrown) {
            HException ex = new HException(thrown);
            Trace.trace(TRACE_MASKD, "Got anException = " + ServiceHistoryServerTasklet.getStackTrace(ex));
            return null;
        }
    }

    public PanelBean getServiceInformationBean() throws TaskletException {
        Trace.trace(TRACE_MASKF, "<--> getServiceInformationBean()");
        SystemMapping mapElement = (SystemMapping)this._sdpMap.get(this._workingSystem);
        ServiceDataProvider sdp = mapElement._sdp;
        ObjectId obId = mapElement._obId;
        UserContext userContext = UserContext.getCurrentUserContext();
        boolean ceMode = false;
        if (User.getUser().hasAuth("base.rolegroup.pedebug")) {
            Trace.trace(TRACE_MASKD, "pe mode");
            ceMode = true;
        }
        if (User.getUser().hasAuth("base.rolegroup.service")) {
            Trace.trace(TRACE_MASKD, "ce mode");
            ceMode = true;
        }
        try {
            this.showBusyDialog(new LocalizableText(BaseTextBundle.getBundleName(), "service.history.title"), new LocalizableText(BaseTextBundle.getBundleName(), "servhist.busy.text"));
            PanelBean pb = null;
            if (ceMode) {
                Trace.trace(TRACE_MASKD, "get the ce mode panel");
                pb = sdp.getServiceInformationBeanCE(obId, this._workingProblem, this._workingSystem);
            } else {
                pb = sdp.getServiceInformationBeanOperator(obId, this._workingProblem, this._workingSystem);
            }
            this.destroyBusyDialog();
            return pb;
        }
        catch (Throwable thrown) {
            TaskletException ex = new TaskletException(thrown);
            Trace.trace(TRACE_MASKD, "Got anException = " + ServiceHistoryServerTasklet.getStackTrace(ex));
            throw ex;
        }
    }

    static String getStackTrace(Throwable throwable) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(1024);
        throwable.printStackTrace(new PrintStream(baos));
        return baos.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static class SystemMapping {
        public ObjectId _obId = null;
        public ServiceDataProvider _sdp = null;
        public long _earliestProblem = Long.MAX_VALUE;
        public long _latestProblem = Long.MIN_VALUE;

        SystemMapping() {
        }

        public void addTime(Date aDate) {
            long _theTime = aDate.getTime();
            if (this._earliestProblem > _theTime) {
                Trace.trace(ServiceHistoryServerTasklet.TRACE_MASKD, "set _earliestProblem to the passed time");
                this._earliestProblem = _theTime;
            }
            if (this._latestProblem < _theTime) {
                Trace.trace(ServiceHistoryServerTasklet.TRACE_MASKD, "set _latestProblem to the passed time");
                this._latestProblem = _theTime;
            }
        }
    }
}

